/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search.matchhighlight;

import guideme.internal.shaded.lucene.search.matchhighlight.OffsetRange;
import guideme.internal.shaded.lucene.search.matchhighlight.Passage;
import guideme.internal.shaded.lucene.search.matchhighlight.PassageSelector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.RandomAccess;
import java.util.function.Function;

public class PassageFormatter {
    private final String ellipsis;
    private final Function<OffsetRange, String> markerStart;
    private final Function<OffsetRange, String> markerEnd;
    private final ArrayList<OffsetRange> markerStack = new ArrayList();

    public PassageFormatter(String ellipsis, String markerStart, String markerEnd) {
        this(ellipsis, (OffsetRange m) -> markerStart, (OffsetRange m) -> markerEnd);
    }

    public PassageFormatter(String ellipsis, Function<OffsetRange, String> markerStart, Function<OffsetRange, String> markerEnd) {
        this.ellipsis = ellipsis;
        this.markerStart = markerStart;
        this.markerEnd = markerEnd;
    }

    public List<String> format(CharSequence value, List<Passage> passages, List<OffsetRange> ranges) {
        assert (PassageSelector.sortedAndNonOverlapping(passages));
        assert (PassageSelector.sortedAndNonOverlapping(ranges));
        assert (this.withinRange(new OffsetRange(0, value.length()), passages));
        assert (ranges instanceof RandomAccess);
        if (ranges.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder buf = new StringBuilder();
        int rangeIndex = 0;
        OffsetRange range = ranges.get(rangeIndex);
        block0: for (Passage passage : passages) {
            while (passage.from >= range.to) {
                if (++rangeIndex == ranges.size()) break block0;
                range = ranges.get(rangeIndex);
            }
            assert (range.from <= passage.from && range.to >= passage.to) : range + " ? " + passage;
            buf.setLength(0);
            if (range.from < passage.from) {
                buf.append(this.ellipsis);
            }
            this.format(buf, value, passage);
            if (range.to > passage.to) {
                buf.append(this.ellipsis);
            }
            result.add(buf.toString());
        }
        return result;
    }

    private boolean withinRange(OffsetRange limits, List<? extends OffsetRange> contained) {
        contained.forEach(r -> {
            if (r.from < limits.from || r.to > limits.to) {
                throw new AssertionError((Object)String.format(Locale.ROOT, "Range outside of the permitted limit (limit = %s): %s", limits, r));
            }
        });
        return true;
    }

    public StringBuilder format(StringBuilder buf, CharSequence value, Passage passage) {
        switch (passage.markers.size()) {
            case 0: {
                buf.append(value, passage.from, passage.to);
                break;
            }
            case 1: {
                OffsetRange m = passage.markers.iterator().next();
                buf.append(value, passage.from, m.from);
                buf.append(this.markerStart.apply(m));
                buf.append(value, m.from, m.to);
                buf.append(this.markerEnd.apply(m));
                buf.append(value, m.to, passage.to);
                break;
            }
            default: {
                this.markerStack.clear();
                this.multipleMarkers(value, passage, buf, this.markerStack);
            }
        }
        return buf;
    }

    private void multipleMarkers(CharSequence value, Passage p, StringBuilder b, ArrayList<OffsetRange> markerStack) {
        SlicePoint[] slicePoints;
        int at = p.from;
        int max = p.to;
        for (SlicePoint slicePoint : slicePoints = PassageFormatter.slicePoints(p)) {
            b.append(value, at, slicePoint.offset);
            OffsetRange currentMarker = slicePoint.marker;
            switch (slicePoint.type) {
                case START: {
                    markerStack.add(currentMarker);
                    b.append(this.markerStart.apply(currentMarker));
                    break;
                }
                case END: {
                    int markerIndex;
                    int k;
                    for (k = markerIndex = markerStack.lastIndexOf(currentMarker); k < markerStack.size(); ++k) {
                        b.append(this.markerEnd.apply(markerStack.get(k)));
                    }
                    markerStack.remove(markerIndex);
                    for (k = markerIndex; k < markerStack.size(); ++k) {
                        b.append(this.markerStart.apply(markerStack.get(k)));
                    }
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            at = slicePoint.offset;
        }
        if (at < max) {
            b.append(value, at, max);
        }
    }

    private static SlicePoint[] slicePoints(Passage p) {
        SlicePoint[] slicePoints = new SlicePoint[p.markers.size() * 2];
        int x = 0;
        for (OffsetRange m : p.markers) {
            slicePoints[x++] = new SlicePoint(SlicePoint.Type.START, m.from, m);
            slicePoints[x++] = new SlicePoint(SlicePoint.Type.END, m.to, m);
        }
        Comparator<SlicePoint> c = Comparator.comparingInt(pt -> pt.offset).thenComparingInt(pt -> pt.type.ordering).thenComparing((a, b) -> {
            if (a.type == SlicePoint.Type.START) {
                return Integer.compare(b.marker.to, a.marker.to);
            }
            return Integer.compare(b.marker.from, a.marker.from);
        });
        Arrays.sort(slicePoints, c);
        return slicePoints;
    }

    static class SlicePoint {
        public final int offset;
        public final Type type;
        public final OffsetRange marker;

        public SlicePoint(Type t, int offset, OffsetRange m) {
            this.type = t;
            this.offset = offset;
            this.marker = m;
        }

        public String toString() {
            return "(" + this.type + ", " + this.marker + ")";
        }

        static enum Type {
            START(2),
            END(1);

            private final int ordering;

            private Type(int ordering) {
                this.ordering = ordering;
            }
        }
    }
}

