/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.graphics;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import xaero.hud.render.TextureLocations;
import xaero.lib.client.graphics.XaeroRenderType;
import xaero.lib.client.graphics.shader.LibShaders;

public class CustomRenderTypes
extends RenderType {
    public static final RenderType GUI_BILINEAR;
    public static final RenderType GUI_BILINEAR_PREMULTIPLIED;
    public static final RenderType GUI_BILINEAR_NO_DEPTH;
    public static final RenderType GUI_NEAREST;
    public static final RenderType COLORED_WAYPOINTS_BGS;
    public static final RenderType MAP_CHUNK_OVERLAY;
    public static final RenderType MAP_LINES;
    public static final RenderType RADAR_NAME_BGS;
    public static final RenderType DEPTH_CLEAR;

    public static RenderType entityIconRenderType(ResourceLocation texture, EntityIconLayerPhases layerPhases) {
        ImmutableList rendertype$state = new XaeroRenderType.MultiPhaseBuilder().texture((RenderStateShard.EmptyTextureStateShard)layerPhases.texture).transparency(layerPhases.transparency).shader(layerPhases.shader).depthTest(layerPhases.depthTest).writeMaskState(layerPhases.writeMask).cull(layerPhases.cull).lightmap(f_110152_).overlay(f_110154_).target(XaeroRenderType.KEEP_TARGET).build();
        return new XaeroRenderType.MultiPhaseRenderType("xaero_entity_icon", DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, 256, true, true, rendertype$state);
    }

    private CustomRenderTypes(String name, VertexFormat vertexFormat, VertexFormat.Mode drawMode, int expectedBufferSize, boolean hasCrumbling, boolean translucent, Runnable startAction, Runnable endAction) {
        super(name, vertexFormat, drawMode, expectedBufferSize, hasCrumbling, translucent, startAction, endAction);
    }

    public static EntityIconLayerPhases getBasicEntityIconLayerPhases(ResourceLocation texture) {
        return new EntityIconLayerPhases(new RenderStateShard.TextureStateShard(texture, false, false), XaeroRenderType.DEFAULT_TRANSLUCENT_TRANSPARENCY, f_110113_, f_110114_, f_110110_, f_173066_);
    }

    static {
        ImmutableList multiPhaseParameters = new XaeroRenderType.MultiPhaseBuilder().texture((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(TextureLocations.GUI_TEXTURES, false, false)).transparency(XaeroRenderType.DEFAULT_TRANSLUCENT_TRANSPARENCY).shader(new RenderStateShard.ShaderStateShard(() -> LibShaders.POSITION_COLOR_TEX)).cull(f_110110_).target(XaeroRenderType.KEEP_TARGET).build();
        GUI_NEAREST = new XaeroRenderType.MultiPhaseRenderType("xaero_gui_nearest", DefaultVertexFormat.f_85818_, VertexFormat.Mode.QUADS, 256, false, false, multiPhaseParameters);
        multiPhaseParameters = new XaeroRenderType.MultiPhaseBuilder().texture((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(TextureLocations.GUI_TEXTURES, true, false)).transparency(XaeroRenderType.DEFAULT_TRANSLUCENT_TRANSPARENCY).shader(new RenderStateShard.ShaderStateShard(() -> LibShaders.POSITION_COLOR_TEX)).cull(f_110110_).target(XaeroRenderType.KEEP_TARGET).build();
        GUI_BILINEAR = new XaeroRenderType.MultiPhaseRenderType("xaero_gui_bilinear", DefaultVertexFormat.f_85818_, VertexFormat.Mode.QUADS, 256, false, false, multiPhaseParameters);
        multiPhaseParameters = new XaeroRenderType.MultiPhaseBuilder().texture((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(TextureLocations.GUI_TEXTURES, true, false)).transparency(XaeroRenderType.DEFAULT_TRANSLUCENT_TRANSPARENCY).shader(new RenderStateShard.ShaderStateShard(() -> LibShaders.POSITION_COLOR_TEX)).cull(f_110110_).target(XaeroRenderType.KEEP_TARGET).depthTest(RenderStateShard.f_110111_).build();
        GUI_BILINEAR_NO_DEPTH = new XaeroRenderType.MultiPhaseRenderType("xaero_gui_bilinear_no_depth", DefaultVertexFormat.f_85818_, VertexFormat.Mode.QUADS, 256, false, false, multiPhaseParameters);
        multiPhaseParameters = new XaeroRenderType.MultiPhaseBuilder().texture((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(TextureLocations.GUI_TEXTURES, true, false)).transparency(XaeroRenderType.PREMULTIPLIED_TRANSPARENCY).shader(new RenderStateShard.ShaderStateShard(() -> LibShaders.POSITION_COLOR_TEX_PRE)).cull(f_110110_).target(XaeroRenderType.KEEP_TARGET).build();
        GUI_BILINEAR_PREMULTIPLIED = new XaeroRenderType.MultiPhaseRenderType("xaero_gui_bilinear_pre", DefaultVertexFormat.f_85818_, VertexFormat.Mode.QUADS, 256, false, false, multiPhaseParameters);
        multiPhaseParameters = new XaeroRenderType.MultiPhaseBuilder().transparency(XaeroRenderType.DEFAULT_TRANSLUCENT_TRANSPARENCY).shader(new RenderStateShard.ShaderStateShard(() -> LibShaders.POSITION_COLOR)).target(XaeroRenderType.KEEP_TARGET).layering(XaeroRenderType.DEFAULT_POLYGON_OFFSET_LAYERING).build();
        COLORED_WAYPOINTS_BGS = new XaeroRenderType.MultiPhaseRenderType("xaero_colored_waypoints", DefaultVertexFormat.f_85815_, VertexFormat.Mode.QUADS, 256, false, false, multiPhaseParameters);
        multiPhaseParameters = new XaeroRenderType.MultiPhaseBuilder().transparency(XaeroRenderType.DEFAULT_TRANSLUCENT_TRANSPARENCY).shader(new RenderStateShard.ShaderStateShard(() -> LibShaders.POSITION_COLOR)).target(XaeroRenderType.KEEP_TARGET).layering(XaeroRenderType.DEFAULT_POLYGON_OFFSET_LAYERING).build();
        RADAR_NAME_BGS = new XaeroRenderType.MultiPhaseRenderType("xaero_radar_name_bg", DefaultVertexFormat.f_85815_, VertexFormat.Mode.QUADS, 256, false, false, multiPhaseParameters);
        multiPhaseParameters = new XaeroRenderType.MultiPhaseBuilder().transparency(XaeroRenderType.DEFAULT_TRANSLUCENT_TRANSPARENCY).shader(new RenderStateShard.ShaderStateShard(() -> LibShaders.POSITION_COLOR)).target(XaeroRenderType.KEEP_TARGET).build();
        MAP_CHUNK_OVERLAY = new XaeroRenderType.MultiPhaseRenderType("xaero_chunk_overlay", DefaultVertexFormat.f_85815_, VertexFormat.Mode.QUADS, 256, false, false, multiPhaseParameters);
        multiPhaseParameters = new XaeroRenderType.MultiPhaseBuilder().transparency(XaeroRenderType.LINES_TRANSPARENCY).shader(new RenderStateShard.ShaderStateShard(() -> LibShaders.FRAMEBUFFER_LINES)).target(XaeroRenderType.KEEP_TARGET).build();
        MAP_LINES = new XaeroRenderType.MultiPhaseRenderType("xaero_lines", DefaultVertexFormat.f_166851_, VertexFormat.Mode.LINES, 256, false, false, multiPhaseParameters);
        multiPhaseParameters = new XaeroRenderType.MultiPhaseBuilder().transparency(XaeroRenderType.DEFAULT_TRANSLUCENT_TRANSPARENCY).shader(new RenderStateShard.ShaderStateShard(() -> LibShaders.POSITION_COLOR_NO_ALPHA_TEST)).target(XaeroRenderType.KEEP_TARGET).depthTest(f_285579_).writeMaskState(f_110116_).build();
        DEPTH_CLEAR = new XaeroRenderType.MultiPhaseRenderType("xaero_depth_clear", DefaultVertexFormat.f_85815_, VertexFormat.Mode.QUADS, 256, false, false, multiPhaseParameters);
    }

    public static class EntityIconLayerPhases {
        public RenderStateShard.TextureStateShard texture;
        public RenderStateShard.TransparencyStateShard transparency;
        public RenderStateShard.DepthTestStateShard depthTest;
        public RenderStateShard.WriteMaskStateShard writeMask;
        public RenderStateShard.CullStateShard cull;
        public RenderStateShard.ShaderStateShard shader;

        public EntityIconLayerPhases(Object texture, Object transparency, Object depthTest, Object writeMask, Object cull, Object shader) {
            this.texture = (RenderStateShard.TextureStateShard)texture;
            this.transparency = (RenderStateShard.TransparencyStateShard)transparency;
            this.depthTest = (RenderStateShard.DepthTestStateShard)depthTest;
            this.writeMask = (RenderStateShard.WriteMaskStateShard)writeMask;
            this.cull = (RenderStateShard.CullStateShard)cull;
            this.shader = (RenderStateShard.ShaderStateShard)shader;
        }
    }
}

