/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.caverns_and_chasms.common.block.entity;

import com.teamabnormals.caverns_and_chasms.common.block.ToolboxBlock;
import com.teamabnormals.caverns_and_chasms.common.inventory.ToolboxMenu;
import com.teamabnormals.caverns_and_chasms.core.other.tags.CCItemTags;
import com.teamabnormals.caverns_and_chasms.core.registry.CCBlockEntityTypes;
import com.teamabnormals.caverns_and_chasms.core.registry.CCSoundEvents;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class ToolboxBlockEntity
extends RandomizableContainerBlockEntity
implements WorldlyContainer {
    private static final int[] SLOTS = IntStream.range(0, 9).toArray();
    private NonNullList<ItemStack> itemStacks = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
    private int openCount;
    private AnimationStatus animationStatus = AnimationStatus.CLOSED;
    private float progress;
    private float progressOld;

    public ToolboxBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CCBlockEntityTypes.TOOLBOX.get(), pos, state);
    }

    public static void tick(Level p_155673_, BlockPos p_155674_, BlockState p_155675_, ToolboxBlockEntity p_155676_) {
        p_155676_.updateAnimation(p_155673_, p_155674_, p_155675_);
    }

    private void updateAnimation(Level p_155680_, BlockPos p_155681_, BlockState p_155682_) {
        this.progressOld = this.progress;
        switch (this.animationStatus) {
            case CLOSED: {
                this.progress = 0.0f;
                break;
            }
            case OPENING: {
                this.progress += 0.1f;
                if (!(this.progress >= 1.0f)) break;
                this.animationStatus = AnimationStatus.OPENED;
                this.progress = 1.0f;
                ToolboxBlockEntity.doNeighborUpdates(p_155680_, p_155681_, p_155682_);
                break;
            }
            case CLOSING: {
                this.progress -= 0.1f;
                if (!(this.progress <= 0.0f)) break;
                this.animationStatus = AnimationStatus.CLOSED;
                this.progress = 0.0f;
                ToolboxBlockEntity.doNeighborUpdates(p_155680_, p_155681_, p_155682_);
                break;
            }
            case OPENED: {
                this.progress = 1.0f;
            }
        }
    }

    public AnimationStatus getAnimationStatus() {
        return this.animationStatus;
    }

    public int m_6643_() {
        return this.itemStacks.size();
    }

    public boolean m_7531_(int p_59678_, int p_59679_) {
        if (p_59678_ == 1) {
            this.openCount = p_59679_;
            if (p_59679_ == 0) {
                this.animationStatus = AnimationStatus.CLOSING;
                ToolboxBlockEntity.doNeighborUpdates(this.m_58904_(), this.f_58858_, this.m_58900_());
            }
            if (p_59679_ == 1) {
                this.animationStatus = AnimationStatus.OPENING;
                ToolboxBlockEntity.doNeighborUpdates(this.m_58904_(), this.f_58858_, this.m_58900_());
            }
            return true;
        }
        return super.m_7531_(p_59678_, p_59679_);
    }

    private static void doNeighborUpdates(Level p_155688_, BlockPos p_155689_, BlockState p_155690_) {
        p_155690_.m_60701_((LevelAccessor)p_155688_, p_155689_, 3);
    }

    public void m_5856_(Player p_59692_) {
        if (!p_59692_.m_5833_()) {
            if (this.openCount < 0) {
                this.openCount = 0;
            }
            ++this.openCount;
            this.f_58857_.m_7696_(this.f_58858_, this.m_58900_().m_60734_(), 1, this.openCount);
            if (this.openCount == 1) {
                this.f_58857_.m_142346_((Entity)p_59692_, GameEvent.f_157803_, this.f_58858_);
                this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)CCSoundEvents.TOOLBOX_OPEN.get(), SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
            }
        }
    }

    public void m_5785_(Player player) {
        if (!player.m_5833_()) {
            --this.openCount;
            this.f_58857_.m_7696_(this.f_58858_, this.m_58900_().m_60734_(), 1, this.openCount);
            if (this.openCount <= 0) {
                this.f_58857_.m_142346_((Entity)player, GameEvent.f_157802_, this.f_58858_);
                this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)CCSoundEvents.TOOLBOX_CLOSE.get(), SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
            }
        }
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.caverns_and_chasms.toolbox");
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.loadFromTag(tag);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (!this.m_59634_(tag)) {
            ContainerHelper.m_18976_((CompoundTag)tag, this.itemStacks, (boolean)false);
        }
    }

    public void loadFromTag(CompoundTag tag) {
        this.itemStacks = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(tag) && tag.m_128425_("Items", 9)) {
            ContainerHelper.m_18980_((CompoundTag)tag, this.itemStacks);
        }
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.itemStacks;
    }

    protected void m_6520_(NonNullList<ItemStack> items) {
        this.itemStacks = items;
    }

    public int[] m_7071_(Direction direction) {
        return SLOTS;
    }

    public boolean m_7155_(int p_59663_, ItemStack stack, @Nullable Direction direction) {
        return !(Block.m_49814_((Item)stack.m_41720_()) instanceof ToolboxBlock) && (stack.m_41720_().m_41465_() || stack.m_204117_(CCItemTags.ADDITIONAL_TOOLBOX_TOOLS));
    }

    public boolean m_7157_(int p_59682_, ItemStack stack, Direction direction) {
        return true;
    }

    public float getProgress(float p_59658_) {
        return Mth.m_14179_((float)p_59658_, (float)this.progressOld, (float)this.progress);
    }

    protected AbstractContainerMenu m_6555_(int p_59660_, Inventory p_59661_) {
        return new ToolboxMenu(p_59660_, p_59661_, (Container)this);
    }

    protected IItemHandler createUnSidedHandler() {
        return new SidedInvWrapper((WorldlyContainer)this, Direction.UP);
    }

    public static enum AnimationStatus {
        CLOSED,
        OPENING,
        OPENED,
        CLOSING;

    }
}

